%
% Create Laplacian from Ajancy Matrix
%
% Synopsis:
%  L = GraphLap(W, type)
% Input:
%  W: Symmetric Ajancy matrix
%  Type (optional, default: 1): 
%    1: Symmetric normalize
%    2: Unnormalize
%    3: Aymmetric normalize 
%
function [L W] = GraphLap(W, type)

  if ~exist('type','var')
    type = 1;
  end
  for i = 1:size(W,1)
    W(i,i) = 0;
  end

  if type == 1
    Di = sqrt(1./sum(W))';
    L = eye(size(W)) - (Di * Di') .* W;

    if any(isnan(L(:)))
      I = eye(size(W));
      sW = sum(W,2);  
      DiTemp = zeros(size(sW));
      DiTemp(sW > 0) = 1./sqrt(sW(sW > 0));
      DiTemp(sW <= 0) = 0;
      Di = DinvTemp';
      for i = find(sW <= 0)
        I(i,i) = 0;
      end
      L = I - (Di * Di') .* W;

      L(sW <= 0,:) = 0;
      L(:,sW <= 0)  = 0;
      L(sW <= 0, sW <= 0) = 0;  
      
      L(isnan(L)) = 0;
    end
  elseif type == 2
    L = diag(sum(W)) - W;
  else
    L = eye(size(W)) - inv(diag(sum(W)))*W;
  end