% --------------------------------------------------
% Simple example of SMGI with toy data
% --------------------------------------------------

clear;
fprintf('--------------------------------------------------\n')
fprintf('Simple demo program for SMGI\n')
fprintf('--------------------------------------------------\n')

rand('seed',1);
randn('seed',1);

ext = '.png';
nNode = 30;
nClass = 3;

Y = zeros(nNode, nClass);
Y(1:10,1) = 1;
Y(11:20,2) = 1;
Y(21:30,3) = 1;
[~,trueLab] = max(Y,[],2);

nGraphTrue = 3;
nGraphNoise = 2;

%
% For true graph, edge probability is set by
% p(edge_ij) = 0.8 if i and j in the same class
% p(edge_ij) = 0.05 otherwise
%
P = Y * Y';
P(P>0) = P(P>0) - 0.2;
P(P==0) = 0.05;
for i = 1:nGraphTrue
  W{i} = GeneGraph(P);
  W{i} = max(W{i},W{i}');  
  L{i} = GraphLap(W{i},1);
end

%
% For noise graph (Random)
%
P = rand(size(P))/2;
for i = (nGraphTrue+1):(nGraphTrue+nGraphNoise);
  W{i} = GeneGraph(P);
  W{i} = max(W{i},W{i}');
  L{i} = GraphLap(W{i},1);
end

trY = zeros(size(Y));
trIdx = [1 11 21]';
trY(trIdx,:) = Y(trIdx,:);

fprintf('-------------------------\n')
fprintf('SMGI starts ...\n')

options.lambda1 = 1;
options.lambda2 = 0.01;
[F u] = SMGI(trY,L,options);

fprintf('-------------------------\n')
fprintf('Plots start ...\n')

colmap3 = [[255 0 0]/255; [0 255 0]/255; [0 0 255]/255];
colmapAll = [[0 0 0]/255; colmap3]; 

edge_col = [100 100 100]/255;
MarkerSize = 10;
col_data = ones(size(Y,1),1);
col_data(trIdx) = 1 + trueLab(trIdx); % unlabeled: 1
                                      % labeled: 1 + label

fprintf('[ Five input graphs ]: \n')
for j = 1:length(W)

  figure;
  colormap(colmapAll);
  if j == 1    
    ginfo = plotGraph(W{j}, MarkerSize, edge_col, col_data);
    XData = ginfo.XData;
    YData = ginfo.YData;
  else
    ginfo = plotGraph(W{j}, MarkerSize, edge_col, col_data, XData, YData);
  end
  axis off;
  saveas(gcf,['Demo-InputGraph',num2str(j),ext]);
  fprintf([' Demo-InputGraph',num2str(j),ext,'\n'])
end

Lall = u(1)*L{1} + u(2)*L{2} + u(3)*L{3};
Wall = max(eye(nNode)-Lall,0);

WallTemp = Wall';
for i = 1:size(Wall,1)
  for j = (i+1):size(Wall,1)
    WallTemp(i,j) = 0; % Remove upper triangluar part
  end
end
idx = find(WallTemp(:));
weight = 30*WallTemp(idx); % Edge weight is set to proportional 
                           % to estimated edge weight

figure
colormap(colmapAll);
ginfo = plotGraph(Wall, MarkerSize, edge_col, col_data, XData, YData);
ginfo.LineWidth = weight;
axis off;
saveas(gcf,['Demo-CombinedGraph',ext]);

fprintf('[ Combined graph ]: \n');
fprintf([' Demo-CombinedGraph',ext,'\n']);

figure
colormap(colmap3);
[~,pred] = max(F,[],2);
ginfo = plotGraph(Wall, MarkerSize, edge_col, pred, XData, YData);
ginfo.LineWidth = weight;

axis off;
saveas(gcf,['Demo-CombinedGraphWithPrediction',ext]);

fprintf('[ Combined graph (with prediction) ]: \n')
fprintf([' Demo-CombinedGraphWithPrediction',ext,'\n']);

